
using System;
using System.Text;
using System.Collections;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using NppScripts;

//SoldierEPilot 13-10-2014
//For non-commercial use only
public class Script : NppScript
{
 static public string GetSelectedText()
        {
            int start = (int)Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELECTIONSTART, 0, 0);
            int end = (int)Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELECTIONEND, 0, 0);
            var text = new StringBuilder(end - start + 1);
            Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELTEXT, 0, text);
            return text.ToString();
        }

  private static string MultyLine(string listing)
  {
	   Regex rex=new Regex(@";");
	   string s=(rex.Replace(listing,";\n"));
	   return(s);
  }
  
  // *.csv line listing - to sqf listing
  
 private static string RPLS(string tx)
 {
  string nm, code;
  int p=tx.IndexOf(",");
  nm=tx.Substring(0,p-1);
  nm=nm.Replace(@"""", @"");
  nm=nm.Trim();
  nm=nm+ "={\n";
  code=tx.Substring(p+1,tx.Length-p-1);
  code=code.Trim();
  code=code.Replace(@"""""", @"""");
  code=code.Substring(1,code.Length-2); 
  code=MultyLine(code);
  code=code+ "\n};";
  tx=nm+code;
  return (tx);
 }

 //Add  sqf listing to clipboard
 [STAThread]
    public override void Run()
    {
	    string txt;
	    txt=GetSelectedText();
		if ((txt.Length)>0)
		{
			Clipboard.SetText(RPLS(txt), TextDataFormat.Text);
			MessageBox.Show("Ready to paste!");
		}
    }
}

